; Diagnostic ROM part 6
; Test 6 64 RAM in -002 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

; Test 6 64RAM2
;  Switch setting:
;  S6 on
;  --
;  S0 on
;  S1 off
;  S2 off
;  S3 on
;This test the 64 bits of RAM in the -002 6530 chip. It uses the
;March C algorythm. This is a very good test. If it passes, it says
;'Good'. If it fails it says 'Bad nn' Where the nn indicates the
;bad address. Say it displayed Bad C9'. That would indicate that the
;address 1700 + C9 = 17C9 failed. Make sure to start the test from a 
;clean reset by pushing the RS when changing the debug switches or
;when powering up..
; TEST FOR THE 64 BYTES IN -002
; If passes it displays 'Good'
; If a failure, it displays 'Bad nn' where nn is the last two digits
;  of the address of failure. Example if nn = C5 the failed address is
; 17C5. -002's RAM is 17C0 to 17FF.
; This uses the March C algorithm.
; It stops on first failure. The first test is up going so a failure
; of 17C0h may mean that the entire 64 bytes are not being accessed.
; Other addresses could be single or multiple failures

	.ORG $0C00
GOOD		  .BYTE $DE, $DC,$DC, $BD, 
BAD			  .BYTE $00,$DE, $F7, $FC
		  
SETUPDISP LDX #$09		; display GOOD
          STX $1742
          LDA #$1F
          STA $1743
          LDA #$00
          STA $1740
          LDA #$7F
          STA $1741
          RTS
LOOP		  
          JSR SETUPDISP
PASS1     LDX #$09
          STX $1742
          LDY #$04
L1C27     LDA #$00
          STA $1740
          LDA GOOD-1,Y
          STX $1742
          STA $1740
          TYA
          LDY #$80
L1C38     NOP
          NOP
          NOP
          NOP
          DEY
          BNE L1C38
          INX
          INX
          TAY
          DEY
          BNE L1C27
          BEQ PASS1
;
ERROR		  
          TXA				;  between C0 and FF counting up, 3F to 00 down
          BMI L184D
          CLC				; it was counting down during failure
          ADC #$BF
L184D     STA $00			; address of failure
LOOPERR   JSR SETUPDISP
          LDY #$04
L1854     LDA BAD-1,Y		; TABLE
          STX $1742
          STA $1740
          TYA
          LDY #$60
L1860     STA BAD,X		; self modifying RTS
          DEY
          BNE L1860
          INX
          INX
          TAY
          DEY
          BNE L1854
          LDA $00
          LSR A
          LSR A
          LSR A
          LSR A
          AND #$0F
          TAY
          LDA $1FE7,Y
          STX $1742
          STA $1740
          LDY $60
L1880     STA BAD,X
          DEY
          BNE L1880
          INX
          INX
          LDA $00
          AND #$0F
          TAY
          LDA $1FE7,Y
          STX $1742
          STA $1740
          LDY $60
L1898     STA $0C04,X
          DEY
          BNE L1898
          BEQ LOOPERR
RESET		  
          CLD
          LDX #$40
          LDA #$55
L18A5     STA $17BF,X
          DEX
          BNE L18A5
          LDX #$C0
L18AD     LDA #$55
          CMP $1700,X		; test RAM in RRIOT
          BEQ L18B7
          JMP ERROR
		  
L18B7     LDA #$AA
          STA $1700,X
          INX
          BNE L18AD
          LDX #$C0
L18C1     LDA #$AA
          CMP $1700,X
          BEQ L18CB
          JMP ERROR
L18CB     LDA #$55
          STA $1700,X
          INX
          BNE L18C1
          LDX #$40
L18D5     CMP $17BF,X
          BEQ L18DD
          JMP ERROR
L18DD     DEX
          BNE L18D5
          LDX #$40
L18E2     LDA #$55
          CMP $17BF,X
          BEQ L18EC
          JMP ERROR
L18EC     LDA #$AA
          STA $17BF,X
          DEX
          BNE L18E2
          LDX #$40
          NOP
          NOP
          NOP
          NOP
          NOP
L18FB     LDA #$AA
          CMP $17BF,X
          BEQ L1905
          JMP ERROR
L1905     LDA #$55
          STA $17BF,X
          DEX
          BNE L18FB
          LDX #$40
L190F     CMP $17BF,X
          BEQ L1917
          JMP ERROR
L1917     DEX
          BNE L190F
          JMP LOOP
 
;
HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0
		  .ORG $FFFA
VECTOR		  


;
; Reset vectors
;	


          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END